@extends('layouts.app')

@section('htmlheader_title')
    {{--Integrations--}}
@endsection

@section('main-content')
    <table class="table table-striped">
        <thead>
        <tr>
            <th>{{ trans('forms.title') }}</th>
            <th>
                @if ($approved)
                    {{ trans('app.publish') }}
                @else
                    <a href="https://www.facebook.com/{{ $user->page_id }}/publishing_tools/?section=INSTANT_ARTICLES_SETTINGS" target="_blank">{{ trans('app.not_approved') }}</a>

                @endif
            </th>

            <th>{{ trans('app.actions') }}</th>
        </tr>
        </thead>
        <tbody>
            @foreach($data as $key => $value)
                <tr>
                    {{--<td>{{ $value->id }}</td>--}}
                    <td>{{ $value->title }}</td>

                    <td>
                        @if ($approved)
                            @if($value->published)
                                <span class="glyphicon glyphicon-ok-circle"></span>
                                <a href="{{ url('publisher/' . $value->id . '/0') }}" class="action-icon" title="Unpublish">Unpublish</a>
                            @else
                                <span class="glyphicon glyphicon-remove-circle"></span>
                                <a href="{{ url('publisher/' . $value->id . '/1') }}" class="action-icon" title="Publish">Publish</a>
                            @endif
                        @endif
                    </td>

                    <!-- we will also add show, edit, and delete buttons -->
                    <td>
                        <a href="{{ url('articles/' . $value->id) }}" class="action-icon" title="view" target="_blank"><span class="glyphicon glyphicon-eye-open"></span></a>

                        <a href="{{ url('posts/' . $value->id) . '/edit' }}" class="action-icon"><span class="glyphicon glyphicon-pencil"></span></a>

                        {{ Form::open(array('url' => 'posts/' . $value->id, 'class' => 'pull-right', 'id' => 'form'. $value->id)) }}
                        {{ Form::hidden('_method', 'DELETE') }}
                        {{--{{ Form::submit('Delete this Post', array('class' => 'btn btn-warning', 'onClick' => 'return confirm("Are you sure you want to remove the post?")')) }}--}}
                        <a onclick="if (confirm('Are you sure you want to remove the post?')) document.getElementById('form{{ $value->id }}').submit();"><span class="glyphicon glyphicon-trash"></span></a>
                        {{ Form::close() }}
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
@endsection
