@extends('layouts.admin')

@section('htmlheader_title')
    {{--Integrations--}}
@endsection

@section('navbar')
@endsection
@section('sidebar')
@endsection


@section('main-content')

    <div class="container">
        <div class="text-center">
            <h1>{{ trans('app.reg_title') }}</h1>
        </div>
    </div>

    <div class="container">
        <div class="text-left">
            {{ Form::open(array('url'=>'admin/create')) }}
                <div class="login-container">
                    <div class="row">
                        <div class="col-md-4 col-md-offset-4">
                            <div class="panel panel-default ">
                                <div class="panel-heading">
                                    <h2 class="panel-title">{{ trans('forms.fill_form_text') }}</h2>

                                    <ul>
                                        @foreach($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>

                                </div>
                                <div class="panel-body">

                                        <div class="form-group">
                                        {{ Form::label('email', trans('forms.email')) }}
                                        <input type="text" id="email" class="form-control" tabIndex="1" name="email" placeholder="Email address" required autofocus value="">
                                        </div>
                                        <div class="form-group">
                                            {{ Form::label('password', trans('forms.password')) }}
                                            <input type="password" id="pwd" class="form-control" placeholder="Password" required tabIndex="2" size="20" maxsize="30" name="password" value="">
                                        </div>
                                        <div class="form-group">
                                            {{ Form::label('password_confirmation', trans('forms.password_confirmation')) }}
                                            <input type="password" id="pwd_2" class="form-control" placeholder="Password confirm" required tabIndex="2" size="20" maxsize="30" name="password_confirmation" value="">
                                        </div>


                                        <button class="btn btn-primary btn-block" type="submit" name="do_set_config">{{ trans('forms.submit') }}</button>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            {{ Form::close() }}
        </div>
    </div>
                <script>
                    document.forms[0].email.focus();
                </script>

@endsection
