<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/

Route::get('admin/login', 'AdminController@getLogin');
Route::post('admin/login', 'AdminController@postLogin');


Route::get('admin/register', 'AdminController@getRegister');
Route::post('admin/create', 'AdminController@postCreate');

Route::get('admin/forgot', 'AdminController@getForgot');
Route::post('admin/forgot', 'AdminController@postForgot');

//Route::get('/', 'PostController@allArticles');

Route::get('/articles/{id}', 'PostController@show');
Route::get('/articles', 'PostController@allArticles');


Route::get('install', 'InstallController@index');

Route::group(array('before' => 'auth'), function () {
    Route::get('publisher/{id}/{status}', 'FbController@publisher');
    Route::get('home', 'HomeController@index');
    Route::get('admin/logout','AdminController@getLogout');
    Route::resource('posts', 'PostController');
    Route::get('admin/profile', 'AdminController@getProfile');
    Route::post('admin/profile', 'AdminController@postProfile');
    Route::get('admin/config', 'AdminController@getConfig');
    Route::get('admin/config-reset', 'AdminController@getConfigReset');
    Route::post('admin/config', 'AdminController@postConfig');
    Route::get('admin/config2', 'AdminController@getConfig2');

    Route::get('admin/config3', 'AdminController@getConfig3');
    Route::post('admin/config3', 'AdminController@postConfig3');

    Route::get('admin/ads', 'AdminController@getAds');
    Route::post('admin/ads', 'AdminController@postAds');

});


Route::get('{slug}', function($slug) {

    return Redirect::to('admin/login');

})->where('slug', '^.*');