<?php
use Facebook\InstantArticles\Client\Client;
use Facebook\Exceptions\FacebookSDKException;
use Facebook\Facebook;
use Facebook\FacebookRequest;
use Facebook\FacebookApp;

use Facebook\InstantArticles\Elements\InstantArticleInterface;
use Facebook\InstantArticles\Validators\Type;

use Facebook\InstantArticles\Elements\InstantArticle;
use Facebook\InstantArticles\Elements\Header;
use Facebook\InstantArticles\Elements\Time;
use Facebook\InstantArticles\Elements\Ad;
use Facebook\InstantArticles\Elements\Analytics;
use Facebook\InstantArticles\Elements\Author;
use Facebook\InstantArticles\Elements\Image;
use Facebook\InstantArticles\Elements\Video;
use Facebook\InstantArticles\Elements\Caption;
use Facebook\InstantArticles\Elements\Footer;
use Facebook\InstantArticles\Transformer\Transformer;

class MyFacebook
{
    public static function getReviewSubmissionStatus()
    {
        $user = User::firstOrFail();

//        $app = new FacebookApp($user->app_id, $user->app_secret);
/*
        $request = new FacebookRequest(
            $app,
            $user->access_token,
            'GET',
            '/' . $user->page_id,
            array(
                'fields' => 'instant_articles_review_status'
            )
        );

        $response = $request->execute();
        $graphObject = $response->getGraphObject();
//        dd($graphObject);
*/
        /* handle the result */


        try {
            $client = Client::create(
                $user->app_id,
                $user->app_secret,
                $user->access_token,
                $user->page_id,
                false // Use development environment?
            );

            $facebook = new Facebook(array(
                'app_id' => $user->app_id,
                'app_secret' => $user->app_secret,
                'default_graph_version' => 'v2.6',
//            'persistent_data_handler' => $this
                'persistent_data_handler' => 'memory'
            ));
            $facebook->setDefaultAccessToken($user->access_token);

            $client = new Client($facebook,
                $user->page_id,
                false // Use development environment?
            );

    //        $response = $this->facebook->get('me?fields=instant_articles_review_status');

//            $response = $client->getReviewSubmissionStatus();
//            $response = $facebook->get('me?fields=instant_articles_review_status');
            $response = $facebook->get('/' . $user->page_id. '?fields=instant_articles_review_status');
            return $response->getGraphNode()->getField('instant_articles_review_status');
        } catch ( Exception $e ) {
//            dd($e);
            $response = false;
        }

        return $response;
    }
    public static function publisher($id, $status)
    {
        ob_start();
//	    var_dump($status);
//        var_dump($id);
        $data = Post::find($id);
        $user = User::firstOrFail();

// Example loads the html from a file
        $html_file = $data->content;

        $title = $data->title;

        $blog_charset = 'utf-8';



//        $date_time_zone = get_option( 'timezone_string' ) ? new DateTimeZone( get_option( 'timezone_string' ) ) : new DateTimeZone( 'UTC' );
        $date_time_zone = new DateTimeZone( 'UTC' );

        $post_date = date('Y/m/d g:i:s A');
        $post_modified = date('Y/m/d g:i:s A');


// Loads the rules content file
        $rules_file_content = file_get_contents("rules-configuration.json", true);

        $transformer = new Transformer();

        $transformer->loadRules( $rules_file_content );


        $header =
            Header::create()
                ->withPublishTime(
                    Time::create( Time::PUBLISHED )->withDatetime( new DateTime( $post_date, $date_time_zone ) )
                )
                ->withModifyTime(
                    Time::create( Time::MODIFIED )->withDatetime( new DateTime( $post_modified, $date_time_zone ) )
                );


        $document = new DOMDocument();
        libxml_use_internal_errors(true);
        $document->loadHTML( '<?xml encoding="' . $blog_charset . '" ?><h1>' . $title . '</h1>' );
        libxml_use_internal_errors(false);
        $transformer->transform( $header, $document );

//        $transformer = apply_filters( 'instant_articles_transformer_rules_loaded', $transformer );

// Instantiate Instant article
        $instant_article = InstantArticle::create()
            ->withCanonicalUrl( url('articles/' . $id) )
            ->withHeader( $header )
            ->addMetaProperty( 'op:generator:application', 'turbo-instant-publisher' )
            ->addMetaProperty( 'op:generator:application:version', 1 );

        $transformer->transformString( $instant_article, $html_file, $blog_charset );

//        $instant_article = apply_filters( 'instant_articles_transformed_element', $instant_article );

        if ($user->ads)
            self::addAds($instant_article, $user->ads);
        if ($user->analytics)
            self::addAnalytics($instant_article, $user->analytics);

// Instantiate an API client
        $client = Client::create(
            $user->app_id,
            $user->app_secret,
            $user->access_token,
            $user->page_id,
            false // Use development environment?
        );

// Import the article
        try {
                $result = $client->importArticle($instant_article, (bool) $status);
//            $result = $client->importArticle($instant_article, (bool) false);
//            echo "OK!!!!!!!";
//                echo $instant_article->render();
//                dd($result);
            $data->published = (bool) $status;
            $data->save();


//                self::postToPage($data, $user, $facebook);

            return Redirect::to('posts');
        } catch (Exception $e) {
            echo 'Could not import the article: '.$e->getMessage();
        }




    }
    public static function delete($id)
    {
        $user = User::firstOrFail();
        $canonicalURL = url('articles/' . $id);
        $field = 'instant_article';

        $facebook = Client::create(
            $user->app_id,
            $user->app_secret,
            $user->access_token,
            $user->page_id,
            false // Use development environment?
        );

//        $response = $facebook->get('?id=' . $canonicalURL . '&fields=' . $field);
        $response = $facebook->removeArticle($canonicalURL);
//            var_dump($response);
//            dd($response->getGraphNode()->getField('instant_article'));
//        $instantArticle = $response->getGraphNode()->getField($field);
//        $articleID = $instantArticle->getField('id');
//        $facebook->delete($articleID);
//        echo "DELETED!!!!!!!";
    }

    public static function addAds(&$instant_article, $ad_code)
    {
        $header = $instant_article->getHeader();
        $width = 300;
        $height = 250;
        $ad = Ad::create()
            ->enableDefaultForReuse()
            ->withWidth( $width )
            ->withHeight( $height );
        $document = new DOMDocument();
        $fragment = $document->createDocumentFragment();
        $valid_html = @$fragment->appendXML( $ad_code );

        if ( $valid_html ) {
            $ad->withHTML(
                $fragment
            );
            $header->addAd( $ad );
        }
        $instant_article->enableAutomaticAdPlacement();
    }

    public static function addAnalytics(&$instant_article, $analytics_code)
    {
        $document = new DOMDocument();
        $fragment = $document->createDocumentFragment();
        $valid_html = @$fragment->appendXML( $analytics_code );

        if ( $valid_html ) {
            $instant_article
                ->addChild(
                    Analytics::create()
                        ->withHTML(
                            $fragment
                        )
                );
        }
    }
}