<?php

//use Auth;
use Illuminate\Http\Request;
//use Validator;
use Facebook\PersistentData\PersistentDataInterface;


use Facebook\FacebookApp;
use Facebook\HttpClients\HttpClientsFactory;
use Facebook\FacebookClient;
use Facebook\Authentication\AccessToken;
use Facebook\Authentication\OAuth2Client;
use Facebook\Exceptions\FacebookSDKException;
use Facebook\PersistentData\FacebookSessionPersistentDataHandler;
use Facebook\PseudoRandomString\PseudoRandomStringGeneratorFactory;
use Facebook\PseudoRandomString\PseudoRandomStringGeneratorInterface;
use Facebook\Url\FacebookUrlDetectionHandler;
use Facebook\Url\FacebookUrlManipulator;
use Facebook\Url\UrlDetectionInterface;

class AdminController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Registration & Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users, as well as the
    | authentication of existing users. By default, this controller uses
    | a simple trait to add these behaviors. Why don't you explore it?
    |
    */

//    use AuthenticatesAndRegistersUsers, ThrottlesLogins;

    /**
     * Where to redirect users after login / registration.
     *
     * @var string
     */
    protected $redirectTo = 'posts';



    public function getForgot() {
        return View::make('admin.forgot');
    }

    public function postForgot() {
        if ( $user = User::where('email', '=', Input::get('email'))->first()) {

            $data = str_random(6);
            $user->password = Hash::make($data);
            $user->save();
            Mail::send('emails.forgot', array('data' => $data), function ($message) {
                $message->to(Input::get('email'), 'Admin')->subject('Password Reset');
            });
            return Redirect::to('admin/login')->with('message', trans('messages.pass_sent'));
        } else {
            return Redirect::to('admin/forgot')->with('message', trans('messages.wrong_email'))->withInput();
        }
    }


    public function getProfile() {
        return View::make('admin.profile');
    }

    public function postProfile() {
        $validator = Validator::make(Input::all(), User::$update_rules);

        if ($validator->passes()) {
            $user = User::firstOrFail();
            $user->email = Input::get('email');
            $user->password = Hash::make(Input::get('password'));
            $user->save();
            return Redirect::to('admin/profile')->with('message', trans('messages.profile_updated'));
        } else {
            return Redirect::to('admin/profile')->with('message', trans('messages.following_errors'))->withErrors($validator)->withInput();
        }
        return View::make('admin.profile');
    }

    public function getRegister() {
        Install::checkInstallation();
        if (User::count())
            return Redirect::to('admin/login');
        return View::make('admin.register');
    }

    public function postCreate() {
        $validator = Validator::make(Input::all(), User::$rules);

        if ($validator->passes()) {
            $user = new User;
            $user->email = Input::get('email');
            $user->password = Hash::make(Input::get('password'));
            $user->save();

            return Redirect::to('admin/login')->with('message', trans('messages.registration_tanks'));
        } else {
            return Redirect::to('admin/register')->with('message', trans('messages.following_errors'))->withErrors($validator)->withInput();
        }
    }

    public function getLogin() {
        $user = User::firstOrFail();
        if (Auth::check())
            return Redirect::to('posts');
        return View::make('admin.login')
            ->with('user', $user);
    }

    public function postLogin() {
        if (Auth::attempt(array('email'=>Input::get('email'), 'password'=>Input::get('password')), Input::get('remember'))) {
            return Redirect::to($this->redirectTo)->with('message', trans('messages.you_logged_in'));
        } else {
            return Redirect::to('admin/login')
                ->with('message', trans('messages.login_error'))
                ->withInput();
        }
    }

    public function index()
    {
        return view('login');
    }

    public function getLogout()
    {
        Auth::logout();
        return Redirect::to('admin/login')->with('message', trans('messages.logout'));
    }

    public function getConfig() {
        $user = User::firstOrFail();
        if ($user->page_id)
            return View::make('admin.config-done')
                ->with('data', $user);
        if ($user->access_token)
            return Redirect::to('admin/config3');
        if ($user->app_secret)
            return Redirect::to('admin/config2');

        return View::make('admin.config')
            ->with('data', $user);
    }

    public function getConfigReset() {
        $user = User::firstOrFail();
        $user->app_id = "";
        $user->app_secret = "";
        $user->access_token = "";
        $user->page_id = "";
        $user->save();
        return Redirect::to('admin/config')->with('message', trans('messages.profile_updated'));
    }

    public function postConfig() {

// '139', 'instant-articles-option-fb-app', '{\"app_id\":\"1667976396866526\",\"app_secret\":\"35624bf540a4c93edcf455001aa1244d\",\"user_access_token\":\"EAAXtBAShA94BAA3XgMNIPGMZBiuMZClkgM3hK6KW7yqU4ZBt8ABCbtF8vd0IBBhbMfnIWSVW3LFD6EsSQzgLGCeq9F30jbMvM3HMfXSbGr4qQ2ApELig6fsqxmPhHWhiy9KMaJYjayOIE9viy9k1L1sV3abgPuIyS4o31EtbwZDZD\"}', 'yes'


//        '140', 'instant-articles-option-fb-page', '{\"page_id\":\"686180148224187\",\"page_name\":\"Laravel Tips\",\"page_picture\":\"https:\\/\\/scontent.xx.fbcdn.net\\/v\\/t1.0-1\\/c15.0.50.50\\/p50x50\\/399548_10149999285987789_1102888142_n.png?oh=a11bfa7aff4c7bb9409f884990892b07&oe=58974A6A\",\"page_access_token\":\"EAAXtBAShA94BAFSlrlfx8m3WXD5E1V09y6hHTRxkpn1rupN1D5ytZBjm3d2ZBQpj7mBZCndv5Ap0jc4wRn6ZCtZCqhtJijk3WdHdGCdCyESum2HqoLvunpXBBVC342agubUNyZBOYAHijq0k3l4CFRQDcPEFciJ5u4SaXFtdJpEwZDZD\",\"supports_instant_articles\":true}', 'yes'


//        $validator = Validator::make(Input::all(), User::$update_rules);

//        if ($validator->passes()) {
            $user = User::firstOrFail();
            $user->app_id = Input::get('app_id');
            $user->app_secret = Input::get('app_secret');
//            $user->access_token = Input::get('access_token');
//            $user->page_id = Input::get('page_id');
            $user->save();
            return Redirect::to('admin/config2')->with('message', trans('messages.config_updated'));
//        } else {
//            return Redirect::to('admin/config')->with('message', trans('messages.following_errors'))->withErrors($validator)->withInput();
//        }
//        return View::make('admin.profile');
    }

    public function getConfig2() {
        $user = User::firstOrFail();
        $fb_app_permissions = array( 'pages_manage_instant_articles', 'pages_show_list' );
//        $fb_app_permissions = array( 'pages_manage_instant_articles', 'pages_show_list', 'publish_pages', 'manage_pages' );

        $fb_sdk = new Facebook\Facebook(array(
            'app_id' => $user->app_id,
            'app_secret' => $user->app_secret,
            'default_graph_version' => 'v2.6',
//            'persistent_data_handler' => $this
            'persistent_data_handler' => 'memory'
        ));

        $helper = $fb_sdk->getRedirectLoginHelper();

        $login_url = $helper->getLoginUrl(
//            Instant_Articles_Settings::get_href_to_settings_page(),
            url('admin/config3'),
            $fb_app_permissions
        );

//        dd($login_url);

        return View::make('admin.config2')
            ->with('login_url', $login_url);
    }

    public function getConfig3()
    {
        if (!Input::get('code'))
            return Redirect::to('admin/config2');
        $user = User::firstOrFail();
//        $redirectUrl = $redirectUrl ?: $this->urlDetectionHandler->getCurrentUrl();
        if (!$user->access_token) {
            $redirectUrl = url('admin/config3');
            // At minimum we need to remove the state param
//        $redirectUrl = FacebookUrlManipulator::removeParamsFromUrl($redirectUrl, ['state']);
            /*
                    new FacebookRedirectLoginHelper(
                        $this->getOAuth2Client(),
                        $this->persistentDataHandler,
                        $this->urlDetectionHandler,
                        $this->pseudoRandomStringGenerator
                    );
            */
            $app = new FacebookApp($user->app_id, $user->app_secret);
            $client = new FacebookClient(HttpClientsFactory::createHttpClient(null, false));
            $oAuth2Client = new OAuth2Client($app, $client, \Facebook\Facebook::DEFAULT_GRAPH_VERSION);

            $access_token = $oAuth2Client->getAccessTokenFromCode(Input::get('code'), $redirectUrl)->getValue();
            $accessToken = $oAuth2Client->getLongLivedAccessToken($access_token);
            $user->access_token = $accessToken->getValue();
            $user->save();

        }

        $fb_sdk = new Facebook\Facebook(array(
            'app_id' => $user->app_id,
            'app_secret' => $user->app_secret,
            'default_graph_version' => 'v2.6',
//            'persistent_data_handler' => $this
            'persistent_data_handler' => 'memory'
        ));
        // Set this access token as the default
//        $fb_sdk->setDefaultAccessToken($accessToken);
        $fb_sdk->setDefaultAccessToken($user->access_token);

        // Request the list of pages and associated page tokens that are
        // connected to this user
        try {
            $response = $fb_sdk->get('/me/accounts?fields=name,id,access_token,supports_instant_articles,picture');
        } catch (FacebookResponseException $e) {
            throw new FacebookSDKException('Graph API returned an error: ' . $e->getMessage());
        }

        // Return the array of page objects for this user


        $page_nodes = $response->getGraphEdge()->all();

        $pages = array();

        // Map GraphNode objects to simple value objects that are smaller when serialized.
        foreach ( $page_nodes as $page_node ) {
            $pages[ $page_node->getField( 'id' ) ] = array(
                'page_id' => $page_node->getField( 'id' ),
                'page_name' => $page_node->getField( 'name' ),
                'page_picture' => $page_node->getField( 'picture' )->getField( 'url' ),
                'page_access_token' => $page_node->getField( 'access_token' ),
                'supports_instant_articles' => $page_node->getField( 'supports_instant_articles' ),
            );
        }
        $data = array();
        $data['pages'] = array();
        $data['pages_other'] = array();
        foreach ( $pages as $v ) {
            if ($v['supports_instant_articles'])
                $data['pages'][] = $v;
            else
                $data['pages_other'][] = $v;
        }
        return View::make('admin.config3')
            ->with('data', $data);

    }

    public function postConfig3()
    {
        $user = User::firstOrFail();
        $user->page_id = Input::get('page_id');
        $user->save();
        return Redirect::to('admin/config')->with('message', trans('messages.config_updated'));
    }

    public function getAds() {
        $user = User::firstOrFail();
        return View::make('admin.ads')
            ->with('data', $user);
    }

    public function postAds()
    {
        $user = User::firstOrFail();
        $user->ads = Input::get('ads');
        $user->save();
        return Redirect::to('admin/ads')->with('message', trans('messages.config_updated'));
    }


}


