@extends('layouts.app')

@section('htmlheader_title')
    {{--Integrations--}}
@endsection
@section('main-content')
    <h1>{{ trans('app.admin_config') }}</h1>
    <hr />
    <h3>{{ trans('app.admin_config_step3') }}</h3>

    <div class="col-md-5">
        @if ($data['pages'])
            {{ Form::open(array('url'=>'admin/config3', 'class'=>'')) }}
            @foreach ($data['pages'] as $v)
                <p>
                    {{ Form::radio('page_id', $v['page_id']) }}
                    <img src="{{ $v['page_picture'] }}"> {{ $v['page_name'] }}
                </p>
            @endforeach
            {{ Form::submit(trans('forms.save'), array('class'=>'btn btn-large btn-primary btn-block'))}}
            {{ Form::close() }}
        @else
            {{ trans('app.admin_config_no_pages') }}
            @if ($data['pages_other'])
                {{ trans('app.admin_config_enable_page') }}
                @foreach($data['pages_other'] as $v)
                    <p><img src="{{ $v['page_picture'] }}"> {{ $v['page_name'] }} </p>
                @endforeach
            @endif
        @endif
    </div>
    <div>
        <a href="{{ url('admin/config-reset') }}">Reset Configuration</a>
    </div>
@endsection
