@extends('layouts.app')

@section('htmlheader_title')
    {{--Integrations--}}
@endsection
@section('main-content')
    <h1>{{ trans('app.admin_config') }}</h1>
    <hr />
    <h3>{{ trans('app.admin_config_done') }}</h3>
    <div>{{ trans('app.can_see_on') }} <a href="https://www.facebook.com/{{ $data->page_id }}/publishing_tools/?section=INSTANT_ARTICLES" target="_blank">Facebook</a> </div>
    <div class="col-md-5">
        <!-- if there are creation errors, they will show here -->
        {{ HTML::ul($errors->all()) }}

        {{ Form::open(array('url'=>'admin/config', 'class'=>'')) }}

            <div class="form-group">
                {{ Form::label('app_id', trans('forms.app_id')) }}
                {{ Form::text('app_id', $data->app_id, array('class'=>'form-control','readonly')) }}
            </div>
            <div class="form-group">
                {{ Form::label('app_secret', trans('forms.app_secret')) }}
                {{ Form::text('app_secret', $data->app_secret, array('class'=>'form-control','readonly')) }}
            </div>
            <div class="form-group">
                {{ Form::label('access_token', trans('forms.access_token')) }}
                {{ Form::text('access_token', $data->access_token, array('class'=>'form-control','readonly')) }}
            </div>
            <div class="form-group">
                {{ Form::label('page_id', trans('forms.page_id')) }}
                {{ Form::text('page_id', $data->page_id, array('class'=>'form-control','readonly')) }}
            </div>
{{--            {{ Form::submit(trans('forms.save'), array('class'=>'btn btn-large btn-primary btn-block'))}}--}}
        {{ Form::close() }}
    </div>

    <div>
        <a href="{{ url('admin/config-reset') }}">{{ trans('app.reset_config') }}</a>
    </div>
@endsection
