<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Artisan;
class Install
{
    public static function checkInstallation()
    {
        if(!is_file(Config::get('database.connections.sqlite.database'))) {
            file_put_contents(Config::get('database.connections.sqlite.database'), '');
            chmod(Config::get('database.connections.sqlite.database'), 0655);
            Artisan::call('clear-compiled');
            Artisan::call('optimize');
            Artisan::call('key:generate');
            Artisan::call('migrate:install');
            Artisan::call('migrate', ['--force'=> true ]);
        }

//        if(!is_dir('storage')) {
//            file_put_contents('storage/db/production.sqlite', '');
//            mkdir('storage/framework');
//            mkdir('storage/framework/cache');
//            mkdir('storage/framework/sessions');
//            mkdir('storage/framework/views');
//            mkdir('storage/logs');
//            self::createTables();
//            sleep(3);
//            Artisan::call('migrate:install');
//            Artisan::call('migrate', ['--force'=> true ]);
//        }
    }

    private static function createTables()
    {
        Schema::create('users', function ($table) {
            $table->increments('id');
            $table->string('name')->default('');
            $table->string('email')->unique();
            $table->string('password');
            $table->rememberToken();
            $table->timestamps();
        });
        Schema::create('Posts', function ($table){
            $table->increments('id');
            $table->string('title');
            $table->string('content');
            $table->timestamps();
        });
    }
}