<?php
use Facebook\InstantArticles\Client\Client;

class PostController extends BaseController {

	/**
	 * Display a listing of the resource.
	 *
	 * @return Response
	 */
	public function index()
	{
        // get all the nerds
        $data = Post::all();
        $user = User::firstOrFail();
        $approved = MyFacebook::getReviewSubmissionStatus();
        if (strcasecmp('APPROVED', $approved) == 0)
            $approved =  true;
        else
            $approved =  false;

        // load the view and pass the nerds
        return View::make('posts.index')
            ->with(['data' => $data, 'user' => $user, 'approved' => $approved]);
	}

	public function allArticles()
	{
        // get all the nerds
        $data = Post::all();
        $user = User::firstOrFail();
        // load the view and pass the nerds
        return View::make('posts.articles')
            ->with(['data' => $data, 'user' => $user]);
	}


	/**
	 * Show the form for creating a new resource.
	 *
	 * @return Response
	 */
	public function create()
	{
        return View::make('posts.create');
	}


	/**
	 * Store a newly created resource in storage.
	 *
	 * @return Response
	 */
	public function store()
	{
        // validate
        // read more on validation at http://laravel.com/docs/validation
        $rules = array(
            'title'       => 'required',
            'content'      => 'required'
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('posts/create')
                ->withErrors($validator)
                ->withInput(Input::except('password'));
        } else {
            // store
            $item = new Post;
            $item->title       = Input::get('title');
            $item->content     = Input::get('content');
            $item->save();

            MyFacebook::publisher($item->id, false);

            // redirect
            Session::flash('message', trans('messages.post_created'));
            return Redirect::to('posts');
        }
	}


	/**
	 * Display the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function show($id)
	{
        $data = Post::find($id);

        // show the view and pass the item to it
        return View::make('posts.show')
            ->with('data', $data);
	}


	/**
	 * Show the form for editing the specified resource.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function edit($id)
	{
        $data = Post::find($id);

        // show the view and pass the item to it
        return View::make('posts.edit')
            ->with('data', $data);
	}


	/**
	 * Update the specified resource in storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function update($id)
    {
        // validate
        // read more on validation at http://laravel.com/docs/validation
        $rules = array(
            'title'       => 'required',
            'content'      => 'required'
        );
        $validator = Validator::make(Input::all(), $rules);

        // process the login
        if ($validator->fails()) {
            return Redirect::to('posts/' . $id . '/edit')
                ->withErrors($validator)
                ->withInput(Input::except('password'));
        } else {
            // store
            $item = Post::find($id);
            $item->title       = Input::get('title');
            $item->content      = Input::get('content');
            $item->save();

            MyFacebook::publisher($id, false);

            // redirect
            Session::flash('message', trans('messages.post_updated'));
            return Redirect::to('posts');
        }
	}


	/**
	 * Remove the specified resource from storage.
	 *
	 * @param  int  $id
	 * @return Response
	 */
	public function destroy($id)
	{
        // delete
        $item = Post::find($id);
        $item->delete();

        MyFacebook::delete($id);
        // redirect
        Session::flash('message', trans('messages.post_deleted'));
        return Redirect::to('posts');
	}
/*
	public function pushArticleToFacebook($id)
	{


// Instantiate an API client
        $ia_client = Client::create(
            'APP_ID',
            'APP_SECRET',
            'ACCESS_TOKEN',
            'PAGE_ID'
        );

// Push the article to your Facebook Page
        $ia_client->importArticle($my_article);

// Unpublish an article from your Facebook Page
//        $ia_client->removeArticle($canonical_url);


// Loads the rules content file
        $rules_file_content = file_get_contents("simple-rules.json", true);

// Instantiate Instant article
        $instant_article = InstantArticle::create();

// Creates the transformer and loads the rules
        $transformer = new Transformer();
        $transformer->loadRules($rules_file_content);

// Example loads the html from a file
        $html_file = file_get_contents("simple.html", true);

// Ignores errors on HTML parsing
        libxml_use_internal_errors(true);
        $document = new \DOMDocument();
        $document->loadHTML($html_file);
        libxml_use_internal_errors(false);

// Invokes transformer
        $transformer->transform($instant_article, $document);

// Get errors from transformer
        $warnings = $transformer->getWarnings();

// Renders the InstantArticle markup format
        $result = $instant_article->render();



        $article = InstantArticle::create();
        $transformer->transform($article, $someDocument);

// Instantiate an API client
        $client = Client::create(
            'APP_ID',
    'APP_SECRET',
    'ACCESS_TOKEN',
    'PAGE_ID',
    false // Use development environment?
);

// Import the article
try {
    $client->importArticle($article, $take_live);
} catch (Exception $e) {
    echo 'Could not import the article: '.$e->getMessage();
}

	}
*/





}
